using System;
using System.Xml;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// Select division security response message defined in VistALink protocol. 
	/// </summary>
	public sealed class SecuritySelectDivisionResponseMessage : SecuritySimpleResponseMessage
	{
		/// <summary>
		/// Message response type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string ResponseType = "AV.SelectDivision";

		/// <summary>
		/// Minimalistic constructor allowing to specify only response status. 
		/// </summary>
		/// <param name="responseStatus">Message response status.</param>
		public SecuritySelectDivisionResponseMessage( ResponseStatus responseStatus )
			: this( responseStatus, null) {}

		/// <summary>
		/// This constructor allows setting informative message for the response (usually, this message
		/// will describe the reason for failure). It also requires response status to be specified. 
		/// </summary>
		/// <param name="responseStatus">Message response status.</param>
		/// <param name="message">Optional informative text message. Expected to be human-readable.</param>
		public SecuritySelectDivisionResponseMessage( ResponseStatus responseStatus, string message )
			: base( ResponseType, responseStatus, message ) {}

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="sourceDoc">Source XML document.</param>
		public SecuritySelectDivisionResponseMessage( XmlDocument sourceDoc )
			: base( ResponseType, sourceDoc ) {}
	}
}
